# 注释

C# 支持多种注释方式，以下注释语法不正确的是？

## 答案

```csharp
-- 一位软件开发者曾经说过一句名言：“软件开发最难的部分就是命名。” 
-- 变量的名称不仅必须遵循某些语法规则，还应使代码更易于用户阅读和理解。 
-- 编写一行代码的要求非常多！
```

## 选项

### A

```csharp
namespace Exceltk.Util {
    /// <summary>
    /// Command Parser
    /// </summary>
    public class CommandParser {
    }
}
```

### B

```csharp
// Valid parameters forms:
// {-,/,--}param value(",'))
// Examples: 
// -param1 value1 -param2 value2" 
foreach (string txt in args){

}
```

### C

```csharp

/*
C# 编译器强制执行一些变量名称规则。

变量名称规则

变量名可包含字母数字字符和下划线字符。 不允许使用特殊字符（如英镑 #、短划线 - 或美元符号 $）。
变量名称必须以字母或下划线开头，不能以数字开头。 开发者将下划线用于特殊目的，因此现在请勿使用。
变量名不能是 C# 关键字。 例如，不允许使用以下变量名称声明：float float; 或 string string;。
变量名称区分大小写，这意味着 string MyValue; 和 string myValue; 是两个不同的变量。
*/

```

### D

```csharp
// ## 变量名称约定

// * 变量名称应使用驼峰式大小写形式，这是一种编写样式.
//   * 即第一个单词以小写字母开始，后续每个单词的首字母采用大写形式。 
//   * 例如：string thisIsCamelCase;。
// * 变量名称在应用程序中应具有描述性且有意义。 应为变量选择一个名称，用于表示其将保存的数据类型。
// * 变量名称应是附加在一起的一个或多个完整单词。 
//    * 请勿使用缩写，因为阅读你代码的人可能不清楚该变量的名称。
// * 变量名称不应包含变量的数据类型。 
//    * 你可能会看到使用类似 string strMyValue; 样式的一些建议。 
//    * 这是几年前的热门样式。 但是，大多数开发者不会再遵循此建议。
```
